import os
os.chdir("../")
import sys
sys.path.append(os.path.dirname(os.path.abspath(__file__)))
import numpy as np
import matplotlib.pyplot as plt

RESULT_PATH = "results/multi_booths_old/1/"
print(os.listdir(RESULT_PATH))
NUM_RUNS = 4
NUM_EPISODES = 12000
episodes_indices = [i for i in range(0, NUM_EPISODES, 20)]

CB91_Blue = '#2CBDFE'
CB91_Green = '#47DBCD'
CB91_Pink = '#F3A0F2'
CB91_Purple = '#9D2EC5'
CB91_Violet = '#661D98'
CB91_Amber = '#F5B14C'
seventh_color = "#4b97ec"
# color_list = [CB91_Blue, CB91_Pink, CB91_Green, CB91_Amber, CB91_Purple, CB91_Violet, seventh_color]
color_list = [CB91_Blue, CB91_Pink, CB91_Green]

sender_bv_obl = np.load(RESULT_PATH + "obl_booth_visits_argmax.npy")
sender_bv_obl_mean = np.mean(np.mean(sender_bv_obl, axis = 0), axis = 0)
print("obl: {}".format(sender_bv_obl_mean))

sender_bv_obl_ir = np.load(RESULT_PATH + "obl_booth_visits_ir_argmax.npy")
sender_bv_obl_ir_mean = np.mean(np.mean(sender_bv_obl_ir, axis = 0), axis = 0)
print("obl ir: {}".format(sender_bv_obl_ir_mean))

sender_bv_obl_mi_reward = np.load(RESULT_PATH + "obl_booth_visits_mi_log2_argmax.npy")
sender_bv_obl_mi_reward_mean = np.mean(np.mean(sender_bv_obl_mi_reward, axis = 0), axis = 0)
print("obl mi reward: {}".format(sender_bv_obl_mi_reward_mean))

sender_bv_obl_mi_loss = np.load(RESULT_PATH + "obl_booth_visits_mi_loss_argmax.npy")
sender_bv_obl_mi_loss_mean = np.mean(np.mean(sender_bv_obl_mi_loss, axis = 0), axis = 0)
print("obl mi loss: {}".format(sender_bv_obl_mi_loss_mean))

sender_bv_obl_mi_reward_mi_loss = np.load(RESULT_PATH + "obl_booth_visits_mi_log2_mi_loss_argmax.npy")
sender_bv_obl_mi_reward_mi_loss_mean = np.mean(np.mean(sender_bv_obl_mi_reward_mi_loss, axis = 0), axis = 0)
print("obl mi reward mi loss: {}".format(sender_bv_obl_mi_reward_mi_loss_mean))

bar_names = ["Costly Booth", "Perfect Booth", "Noisy Booth"]
fig, axes = plt.subplots(2, 3)

axes[0, 0].bar(bar_names, sender_bv_obl_mean, color = color_list)
axes[0, 0].set_ylabel("Booth Visits")
axes[0, 0].set_xlabel("Booth")
axes[0, 0].set_title("OBL")
axes[0, 0].set_ylim([0, 20])
axes[0, 0].spines['top'].set_visible(False)
axes[0, 0].spines['right'].set_visible(False)

axes[0, 1].bar(bar_names, sender_bv_obl_ir_mean, color = color_list)
axes[0, 1].set_ylabel("Booth Visits")
axes[0, 1].set_xlabel("Booth")
axes[0, 1].set_title("OBL + IR")
axes[0, 1].set_ylim([0, 20])
axes[0, 1].spines['top'].set_visible(False)
axes[0, 1].spines['right'].set_visible(False)

axes[0, 2].bar(bar_names, sender_bv_obl_mi_reward_mean, color = color_list)
axes[0, 2].set_ylabel("Booth Visits")
axes[0, 2].set_xlabel("Booth")
axes[0, 2].set_title("OBL + MI Reward")
axes[0, 2].set_ylim([0, 20])
axes[0, 2].spines['top'].set_visible(False)
axes[0, 2].spines['right'].set_visible(False)

axes[1, 0].bar(bar_names, sender_bv_obl_mi_loss_mean, color = color_list)
axes[1, 0].set_ylabel("Booth Visits")
axes[1, 0].set_xlabel("Booth")
axes[1, 0].set_title("OBL + MI Loss")
axes[1, 0].set_ylim([0, 20])
axes[1, 0].spines['top'].set_visible(False)
axes[1, 0].spines['right'].set_visible(False)

axes[1, 1].bar(bar_names, sender_bv_obl_mi_reward_mi_loss_mean, color = color_list)
axes[1, 1].set_ylabel("Booth Visits")
axes[1, 1].set_xlabel("Booth")
axes[1, 1].set_title("OBL + MI Reward + MI Loss")
axes[1, 1].set_ylim([0, 20])
axes[1, 1].spines['top'].set_visible(False)
axes[1, 1].spines['right'].set_visible(False)

fig.delaxes(axes[1, 2])

plt.ylim([0, 20])
fig.suptitle("Phone Booth Maze with Multiple Functional Phone Booths (noise = 0.1)")
plt.show()
